/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.PowerpackItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ToolUpgradeItem
extends IEBaseItem
implements IUpgrade {
    private final ToolUpgrade type;

    public ToolUpgradeItem(ToolUpgrade type) {
        super(new Item.Properties().m_41487_(1));
        this.type = type;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)new TranslatableComponent("desc.immersiveengineering.flavour." + this.getRegistryName().m_135815_()).m_130940_(ChatFormatting.GRAY));
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.type.stackSize;
    }

    @Override
    public Set<String> getUpgradeTypes(ItemStack upgrade) {
        return this.type.toolset;
    }

    @Override
    public boolean canApplyUpgrades(ItemStack target, ItemStack upgrade) {
        BiPredicate<ItemStack, ItemStack> check = this.type.applyCheck;
        if (check != null && target.m_41720_() instanceof IUpgradeableTool) {
            return check.test(target, upgrade);
        }
        return true;
    }

    @Override
    public void applyUpgrades(ItemStack target, ItemStack upgrade, CompoundTag modifications) {
        this.type.function.accept(upgrade, modifications);
    }

    public static enum ToolUpgrade {
        DRILL_WATERPROOF((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), (upgrade, modifications) -> modifications.m_128379_("waterproof", true)),
        DRILL_LUBE((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL", (Object)"BUZZSAW"), (upgrade, modifications) -> modifications.m_128379_("oiled", true)),
        DRILL_DAMAGE((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), 3, (upgrade, modifications) -> {
            ItemNBTHelper.modifyFloat(modifications, "speed", (float)upgrade.m_41613_() * 2.0f);
            ItemNBTHelper.modifyInt(modifications, "damage", upgrade.m_41613_());
        }),
        DRILL_FORTUNE((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), (upgrade, modifications) -> modifications.m_128379_("fortune", true)),
        DRILL_CAPACITY((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL", (Object)"CHEMTHROWER", (Object)"BUZZSAW"), 1, (target, upgrade) -> !((IUpgradeableTool)target.m_41720_()).getUpgrades((ItemStack)target).m_128441_("multitank"), (upgrade, modifications) -> ItemNBTHelper.modifyInt(modifications, "capacity", 2000)),
        REVOLVER_BAYONET((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), (upgrade, modifications) -> ItemNBTHelper.modifyFloat(modifications, "melee", 6.0f)),
        REVOLVER_MAGAZINE((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), 1, (target, upgrade) -> !((IUpgradeableTool)target.m_41720_()).getUpgrades((ItemStack)target).m_128441_("bullets"), (upgrade, modifications) -> ItemNBTHelper.modifyInt(modifications, "bullets", 6)),
        REVOLVER_ELECTRO((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), (upgrade, modifications) -> modifications.m_128379_("electro", true)),
        CHEMTHROWER_FOCUS((ImmutableSet<String>)ImmutableSet.of((Object)"CHEMTHROWER"), (upgrade, modifications) -> modifications.m_128379_("focus", true)),
        RAILGUN_SCOPE((ImmutableSet<String>)ImmutableSet.of((Object)"RAILGUN", (Object)"REVOLVER"), (upgrade, modifications) -> modifications.m_128379_("scope", true)),
        RAILGUN_CAPACITORS((ImmutableSet<String>)ImmutableSet.of((Object)"RAILGUN"), (upgrade, modifications) -> modifications.m_128350_("speed", 1.0f)),
        SHIELD_FLASH((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.m_128379_("flash", true)),
        SHIELD_SHOCK((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.m_128379_("shock", true)),
        SHIELD_MAGNET((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.m_128379_("magnet", true)),
        CHEMTHROWER_MULTITANK((ImmutableSet<String>)ImmutableSet.of((Object)"CHEMTHROWER"), 1, (target, upgrade) -> !((IUpgradeableTool)target.m_41720_()).getUpgrades((ItemStack)target).m_128441_("capacity"), (upgrade, modifications) -> modifications.m_128379_("multitank", true)),
        BUZZSAW_SPAREBLADES((ImmutableSet<String>)ImmutableSet.of((Object)"BUZZSAW"), 1, (upgrade, modifications) -> modifications.m_128379_("spareblades", true)),
        POWERPACK_ANTENNA((ImmutableSet<String>)ImmutableSet.of((Object)"POWERPACK"), 1, (target, upgrade) -> !PowerpackItem.getUpgradesStatic(target).m_128441_("tesla"), (upgrade, modifications) -> modifications.m_128379_("antenna", true)),
        POWERPACK_INDUCTION((ImmutableSet<String>)ImmutableSet.of((Object)"POWERPACK"), 1, (upgrade, modifications) -> modifications.m_128379_("induction", true)),
        POWERPACK_TESLA((ImmutableSet<String>)ImmutableSet.of((Object)"POWERPACK"), 1, (target, upgrade) -> !PowerpackItem.getUpgradesStatic(target).m_128441_("antenna"), (upgrade, modifications) -> modifications.m_128379_("tesla", true));

        private ImmutableSet<String> toolset;
        private int stackSize = 1;
        private BiPredicate<ItemStack, ItemStack> applyCheck;
        private BiConsumer<ItemStack, CompoundTag> function;

        private ToolUpgrade(ImmutableSet<String> toolset, BiConsumer<ItemStack, CompoundTag> function) {
            this(toolset, 1, function);
        }

        private ToolUpgrade(ImmutableSet<String> toolset, int stackSize, BiConsumer<ItemStack, CompoundTag> function) {
            this(toolset, stackSize, null, function);
        }

        private ToolUpgrade(ImmutableSet<String> toolset, int stackSize, BiPredicate<ItemStack, ItemStack> applyCheck, BiConsumer<ItemStack, CompoundTag> function) {
            this.toolset = toolset;
            this.stackSize = stackSize;
            this.applyCheck = applyCheck;
            this.function = function;
        }
    }
}

